/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Vector;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;

public final class WakeupOnCollisionEntry
extends WakeupCriterion {
    static final int COND_IN_GS_LIST = 0;
    static final int COLLIDEENTRY_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    public static final int USE_GEOMETRY = 10;
    public static final int USE_BOUNDS = 11;
    static final int GROUP = 23;
    static final int BOUNDINGLEAF = 25;
    static final int SHAPE = 11;
    static final int MORPH = 10;
    static final int ORIENTEDSHAPE3D = 28;
    static final int BOUND = 0;
    int accuracyMode;
    NodeRetained armingNode;
    Bounds vwcBounds = null;
    BoundingLeafRetained boundingLeaf = null;
    UnorderList geometryAtoms = null;
    int nodeType;
    SceneGraphPath armingPath = null;
    Bounds armingBounds = null;
    Bounds collidingBounds = null;
    SceneGraphPath collidingPath = null;

    public WakeupOnCollisionEntry(SceneGraphPath sceneGraphPath) {
        this(sceneGraphPath, 11);
    }

    public WakeupOnCollisionEntry(SceneGraphPath sceneGraphPath, int n2) {
        this(new SceneGraphPath(sceneGraphPath), n2, null);
    }

    public WakeupOnCollisionEntry(Node node) {
        this(node, 11);
    }

    public WakeupOnCollisionEntry(Node node, int n2) {
        this(new SceneGraphPath(null, node), n2, null);
    }

    public WakeupOnCollisionEntry(Bounds bounds) {
        this(null, 11, (Bounds)bounds.clone());
    }

    WakeupOnCollisionEntry(SceneGraphPath sceneGraphPath, int n2, Bounds bounds) {
        if (sceneGraphPath != null) {
            this.armingNode = (NodeRetained)sceneGraphPath.getObject().retained;
            this.nodeType = WakeupOnCollisionEntry.getNodeType(this.armingNode, sceneGraphPath, "WakeupOnCollisionEntry");
            this.armingPath = sceneGraphPath;
            WakeupOnCollisionEntry.validateSpeedHint(n2, "WakeupOnCollisionEntry4");
        } else {
            this.armingBounds = bounds;
            this.nodeType = 0;
        }
        this.accuracyMode = n2;
        WakeupIndexedList.init(this, 2);
    }

    public SceneGraphPath getArmingPath() {
        return this.armingPath != null ? new SceneGraphPath(this.armingPath) : null;
    }

    public Bounds getArmingBounds() {
        return this.armingBounds != null ? (Bounds)this.armingBounds.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneGraphPath getTriggeringPath() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry5"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry5"));
            }
        }
        return this.collidingPath != null ? new SceneGraphPath(this.collidingPath) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bounds getTriggeringBounds() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry6"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry6"));
            }
        }
        return this.collidingBounds != null ? (Bounds)this.collidingBounds.clone() : null;
    }

    static int getNodeType(NodeRetained nodeRetained, SceneGraphPath sceneGraphPath, String string) throws IllegalArgumentException {
        if (!sceneGraphPath.validate()) {
            throw new IllegalArgumentException(J3dI18N.getString(string + "7"));
        }
        if (nodeRetained.inBackgroundGroup) {
            throw new IllegalArgumentException(J3dI18N.getString(string + "1"));
        }
        if (nodeRetained instanceof OrientedShape3DRetained) {
            return 28;
        }
        if (nodeRetained instanceof Shape3DRetained) {
            return 11;
        }
        if (nodeRetained instanceof MorphRetained) {
            return 10;
        }
        if (nodeRetained instanceof GroupRetained) {
            return 23;
        }
        if (nodeRetained instanceof BoundingLeafRetained) {
            return 25;
        }
        throw new IllegalArgumentException(J3dI18N.getString(string + "0"));
    }

    static void validateSpeedHint(int n2, String string) throws IllegalArgumentException {
        if (n2 != 10 && n2 != 11) {
            throw new IllegalArgumentException(J3dI18N.getString(string));
        }
    }

    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        switch (this.nodeType) {
            case 11: 
            case 28: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                Shape3DRetained shape3DRetained = (Shape3DRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(shape3DRetained.getMirrorShape(this.armingPath)));
                break;
            }
            case 10: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                MorphRetained morphRetained = (MorphRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(morphRetained.getMirrorShape(this.armingPath)));
                break;
            }
            case 25: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                this.boundingLeaf = ((BoundingLeafRetained)this.armingNode).mirrorBoundingLeaf;
                break;
            }
            case 0: {
                this.vwcBounds = (Bounds)this.armingBounds.clone();
                this.armingNode = this.behav;
                break;
            }
            case 23: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.accuracyMode != 10) break;
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
            }
        }
        this.behav.universe.geometryStructure.addWakeupOnCollision(this);
    }

    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        this.vwcBounds = null;
        if (this.geometryAtoms != null) {
            this.geometryAtoms.clear();
        }
        this.boundingLeaf = null;
        this.behav.universe.geometryStructure.removeWakeupOnCollision(this);
    }

    void setTarget(BHLeafInterface bHLeafInterface) {
        Bounds bounds;
        SceneGraphPath sceneGraphPath;
        if (bHLeafInterface instanceof GeometryAtom) {
            GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
            Shape3DRetained shape3DRetained = geometryAtom.source;
            sceneGraphPath = WakeupOnCollisionEntry.getSceneGraphPath(shape3DRetained.sourceNode, shape3DRetained.key, shape3DRetained.getCurrentLocalToVworld(0));
            bounds = WakeupOnCollisionEntry.getTriggeringBounds(shape3DRetained);
        } else {
            GroupRetained groupRetained = (GroupRetained)bHLeafInterface;
            sceneGraphPath = WakeupOnCollisionEntry.getSceneGraphPath(groupRetained);
            bounds = WakeupOnCollisionEntry.getTriggeringBounds(groupRetained);
        }
        if (sceneGraphPath != null) {
            this.collidingPath = sceneGraphPath;
            this.collidingBounds = bounds;
        }
    }

    void updateCollisionBounds(boolean bl) {
        if (this.nodeType == 23) {
            GroupRetained groupRetained = (GroupRetained)this.armingNode;
            this.vwcBounds = groupRetained.collisionBound != null ? (Bounds)groupRetained.collisionBound.clone() : groupRetained.getEffectiveBounds();
            groupRetained.transformBounds(this.armingPath, this.vwcBounds);
        } else if (this.nodeType == 0) {
            this.vwcBounds.transform(this.armingBounds, this.behav.getCurrentLocalToVworld());
        }
        if (bl && this.nodeType == 23 && this.accuracyMode == 10) {
            this.geometryAtoms.clear();
            ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
        }
    }

    static Bounds getTriggeringBounds(Shape3DRetained shape3DRetained) {
        NodeRetained nodeRetained = shape3DRetained.sourceNode;
        if (nodeRetained instanceof Shape3DRetained) {
            Shape3DRetained shape3DRetained2 = (Shape3DRetained)nodeRetained;
            if (shape3DRetained2.collisionBound == null) {
                return shape3DRetained2.getEffectiveBounds();
            }
            return shape3DRetained2.collisionBound;
        }
        MorphRetained morphRetained = (MorphRetained)nodeRetained;
        if (morphRetained.collisionBound == null) {
            return morphRetained.getEffectiveBounds();
        }
        return morphRetained.collisionBound;
    }

    static Bounds getTriggeringBounds(GroupRetained groupRetained) {
        if (groupRetained.collisionBound == null) {
            return groupRetained.getEffectiveBounds();
        }
        return groupRetained.collisionBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath getSceneGraphPath(GroupRetained groupRetained) {
        Transform3D transform3D = null;
        GroupRetained groupRetained2 = groupRetained.sourceNode;
        Object object = groupRetained2.universe.sceneGraphLock;
        synchronized (object) {
            if (groupRetained.key == null) {
                transform3D = groupRetained2.getCurrentLocalToVworld();
            } else {
                HashKey[] hashKeyArray = groupRetained2.localToVworldKeys;
                if (hashKeyArray == null) {
                    return null;
                }
                transform3D = groupRetained2.getCurrentLocalToVworld(groupRetained.key);
            }
            return WakeupOnCollisionEntry.getSceneGraphPath(groupRetained2, groupRetained.key, transform3D);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath getSceneGraphPath(NodeRetained nodeArray, HashKey hashKey, Transform3D transform3D) {
        Object object = nodeArray.universe.sceneGraphLock;
        synchronized (object) {
            Node[] nodeArray2;
            Node[] nodeArray3 = nodeArray;
            UnorderList unorderList = new UnorderList(5, Node.class);
            Object object2 = nodeArray3;
            Locale locale = object2.locale;
            if (object2.inSharedGroup) {
                hashKey = hashKey != null ? new HashKey(hashKey) : new HashKey(nodeArray.localToVworldKeys[0]);
            }
            do {
                if (object2.source.getCapability(0)) {
                    unorderList.add(object2.source);
                }
                if (object2 instanceof SharedGroupRetained) {
                    String string = hashKey.getLastNodeId();
                    Vector vector = ((SharedGroupRetained)object2).parents;
                    nodeArray2 = object2;
                    for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
                        NodeRetained nodeRetained = (NodeRetained)vector.elementAt(i2);
                        if (!nodeRetained.nodeId.equals(string)) continue;
                        object2 = nodeRetained;
                        break;
                    }
                    if (object2 != nodeArray2) continue;
                    return null;
                }
                if (!(object2 instanceof GroupRetained) || !((GroupRetained)object2).collisionTarget) continue;
                nodeArray3 = object2;
                transform3D = hashKey == null ? object2.getCurrentLocalToVworld(null) : object2.getCurrentLocalToVworld(hashKey);
            } while ((object2 = object2.parent) != null);
            nodeArray2 = nodeArray3 == nodeArray ? (Node[])unorderList.toArray(false) : (Node[])unorderList.toArray(nodeArray3);
            SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, nodeArray2, (Node)nodeArray3.source);
            sceneGraphPath.setTransform(transform3D);
            return sceneGraphPath;
        }
    }

    void setTriggered() {
        if (this.collidingPath != null) {
            super.setTriggered();
        }
    }

    void resetBehaviorCondition(BehaviorStructure behaviorStructure) {
    }
}

